/* eslint-disable @typescript-eslint/no-explicit-any */
import L from "leaflet";

export const createIcon = (param: any, zoom: any) =>
  L.divIcon({
    className: "dummy",
    iconSize: [100, 50],
    html: `
    <div style="zoom:${zoom};overflow:visible">
      ${param}
    </div>`
  });

export const defaultMarker = (height = 20, width = 30) =>
  new L.Icon({
    iconUrl: require("leaflet/dist/images/marker-icon.png"),
    iconSize: new L.Point(height, width)
  });

export const getChildrenProperties = (icon: { props: any; }, properties: { [x: string]: any; }) => {
  let props = icon.props;
  const neededProps = [
    "onClick",
    "onMouseOver",
    "onHover",
    "onHighlight",
    "onMouseOut"
  ];
  while (props && props.children) {
    if (typeof props.children !== "string") {
      const childrenProps = props.children.props;
      neededProps.forEach(prop => {
        if (!properties[prop]) {
          const propList = [];
          childrenProps[prop] && propList.push(childrenProps[prop]);
          properties[prop] = propList;
        } else {
          const propList = properties[prop];
          childrenProps[prop] && propList.push(childrenProps[prop]);
          properties[prop] = propList;
        }
      });
    }
    props = props.children.props;
  }

  return properties;
};